﻿namespace Hims.Api.Controllers
{
    using Hims.Api.Utilities;
    using Hims.Domain.Services;
    using Hims.Shared.DataFilters;
    using Hims.Shared.EntityModels;
    using Microsoft.AspNetCore.Authorization;
    using Microsoft.AspNetCore.Mvc;
    using System.Threading.Tasks;

    /// <inheritdoc />
    [Authorize]
    [Route("api/patient-chat-box")]
    public class PatientChatBoxController : BaseController
    {
        /// <summary>
        /// The idproof services.
        /// </summary>
        private readonly IPatientChatBoxService patientChatBoxService;

        /// <summary>
        /// The audit log services.
        /// </summary>
        private readonly IAuditLogService auditLogServices;

        /// <inheritdoc />
        public PatientChatBoxController(IPatientChatBoxService patientChatBoxService, IAuditLogService auditLogService)
        {
            this.patientChatBoxService = patientChatBoxService;
            this.auditLogServices = auditLogService;
        }

        /// <summary>
        /// Inserts the hoc asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        [HttpPost]
        [Route("add")]
        public async Task<ActionResult> InsertAsync([FromBody] PatientChatBoxModel model)
        {
            model = (PatientChatBoxModel)EmptyFilter.Handler(model);
            var PatientChatBoxId = await this.patientChatBoxService.InsertAsync(model);
            return this.Success(PatientChatBoxId);
        }

        /// <summary>
        /// Fetches all asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        [HttpPost]
        [Route("fetch-all")]
        public async Task<ActionResult> FetchAsync([FromBody] PatientChatBoxModel model)
        {
            model = (PatientChatBoxModel)EmptyFilter.Handler(model);
            var response = await this.patientChatBoxService.FetchAsync(model);
            return this.Success(response);
        }
    }
}
